#include "hprfgw_config.h"
#include "smac_mcu_hw_config.h"
#include "smac_simple_phy.h"
#include "smac_mcu_spi_config.h"
#include "smac_drivers.h"
//#include "hprfgw_rfSharedDefs.h"
//#include "hprfgw_rfSlaveIntToHost.h"
//#include "hprfgw_rfSlaveIntToRfApp.h"
#include "hprf_androidIntfc.h"
/*! Global Variables */

// ISR Details
/* Bit definitions and macros for MCF_INTC0_ICRn */
#define MCF_INTC0_ICRn_IP(x)          (((x)&0x07)<<0)
#define MCF_INTC0_ICRn_IL(x)          (((x)&0x07)<<3)
#define MC13192PHY_INTLEV		       (MCF_INTC0_ICRn_IL(6)|MCF_INTC0_ICRn_IP(7))  // fixed because it's an Ext Interrupt
#define MC13192PHY_VECT			       (70)	
#define MC13192_HISR_PRIORITY      (1)



/* Defines */
// For now, hardcode the values. Use the coldfire .h files later on
// RxTx, Attn, PAEnable, AnswTxEn, AntSwRxEn, GPIO5, GPIO6, Reset pin mask 
// These are specific to the TPS6x
#define gMC1319xAttnMask_c   		(1<<0)
#define gMC1319xResetMask_c  		(1<<1)
#define gMC1319xRxTxMask_c   		(1<<2)
#define gMC1319xAntSwRxEnMask_c  	(1<<3)	
#define gMC1319xAntSwTxEnMask_c  	(1<<4)	
#define gMC1319xPAEnMask_c  		(1<<5)						 
#define gMC1319xGPIO1Mask_c  		(1<<6)							 
#define gMC1319xGPIO2Mask_c  		(1<<7)

#if defined (OS_NUCLEUS)
 RFPHYISRSTRUCT RFPhyISR;
#elif defined (OS_WINCE)
 DWORD HPR_IntrThread(VOID *pContext);
#endif

#if defined (OS_NUCLEUS)
void EnableInterrupt(BOOL hi, UINT32 mask)
{

}

// Use for individual interrupts only.
void DisableInterrupt(BOOL hi, UINT32 mask)
{

}
#endif


/*
 * MC13192ContReset: Reset (continuous) the MC13192.
 *
 * Parameters: None
 *
 * Return : None
 */
void MC13192ContReset()
{
    gu8RTxMode = SYSTEM_RESET_MODE;
    //IRQSC = 0x00;                   /* Set for negative edge. */
    MC1319xDrv_Assert_Reset();        /* Place the MC13192 into reset */
}



/**
 * Init GPIO to expected values.
 */
void SMAC_GPIOInit()
{
    // Setup required GPIOs - configured as output on winceintfc.c file already
	DmSetGPIO(HPRF_GPIONUM_N_RXEN, 1);
    if(crest_get_prodID() != TST900)		// JAS TX_EN is not used on 900
    	DmSetGPIO(HPRF_GPIONUM_N_TX_EN, 1);
	DmSetGPIO(HPRF_GPIONUM_N_ATTN, 0);
}


/**
 * Assert reset to the device.
 */
void MC1319xDrv_Assert_Reset(void)
{
	DmSetGPIO(HPRF_GPIONUM_N_RESET, 0);
}

/**
 * Deassert reset.
 */
void MC1319xDrv_Deassert_Reset(void)
{
	DmSetGPIO(HPRF_GPIONUM_N_RESET, 1);
}




/**
 * Checks the irq line as gpio. Returns 1 if low, 0 otherwise.
 */
UINT8 IRQFLAG(void)
{
    // Read the pin directly
    BOOL val = DmReadGPIO(HPRF_GPIONUM_N_IRQ);
    return !val; /* invert value, function tests for signal low */
}

/*!
  \fn void MCUInit() 
  \brief	Initialize the MCU COP, GPIO, SPI and IRQ.
   Set the desired MC13192 clock frequency here.
  \sa GPIOInit()
  \sa SPIInit()
  \sa IRQInit()
  \sa IRQACK()             
  \sa SPIDrvRead()
  \sa IRQPinEnable() 
*/

 /*!
  \fn UINT8 IRQPinLow() 
  \brief	Checks IRQ Pin to see if is low.
  \return	1 if IRQ is Low   
   
*/
UINT8 IRQPinLow(void)
{
    return IRQFLAG();
}

//#pragma INLINE
//void AssertCE(void){
//  MC13192_CE = 0; /*!< Asserts the MC13192 CE pin */
//}
//#pragma INLINE
//void DeAssertCE(void){
//  MC13192_CE = 1; /*!< Deasserts the MC13192 CE pin */
//}

void RTXENDeAssert(void)
{
	DmSetGPIO(HPRF_GPIONUM_RXTXEN, 0);
    // Delay needed? TODO
    //RFIntHostApp.pF_HwDelayUsec(20);
	/* TODO: Usecs, or msecs delay? */
	HwDelayUsec(20);
}

void RTXENAssert(void)
{
	DmSetGPIO(HPRF_GPIONUM_RXTXEN, 1);
}

void MC13192Wake(void)
{
    /* Assert ATTN then deassert. */
	DmSetGPIO(HPRF_GPIONUM_N_ATTN, 1);
	DmSetGPIO(HPRF_GPIONUM_N_ATTN, 0);
}

void MCU_LOW_POWER_WHILE(void)
{
    //TODO: Wince used 10, for some reason, 15 seems to behave better on android.
	//HwDelayUsec(10);
    usleep_range(10,20);
    //HwDelayMsec(1);
}



#if defined (OS_NUCLEUS)
// MNT - 4/6/2007 - QSPI CS is now configured as a GPIO
__inline void AssertCE(void)
{
    // For WinCE, the SPI driver takes care of it
}

__inline void DeAssertCE(void)
{
    // For WinCE, the SPI driver takes care of it
}
#endif


void MC1319xDrv_TxHighPowerEnable(void)
{
	DmSetGPIO(HPRF_GPIONUM_PAEN, 1);
}

void MC1319xDrv_TxHighPowerDisable(void)
{
	DmSetGPIO(HPRF_GPIONUM_PAEN, 0);
}

void MC1319xDrv_RxAntennaSwitchEnable(void)
{ 
    MC1319xDrv_TxHighPowerDisable();

    if(crest_get_prodID() != TST900)		// JAS TX_EN is not used on 900
    	DmSetGPIO(HPRF_GPIONUM_N_TX_EN, 1);
	DmSetGPIO(HPRF_GPIONUM_N_RXEN, 0);
}

void MC1319xDrv_TxAntennaSwitchEnable(void)
{ 
    MC1319xDrv_TxHighPowerEnable();

	DmSetGPIO(HPRF_GPIONUM_N_RXEN, 1);
    if(crest_get_prodID() != TST900)		// JAS TX_EN is not used on 900
    	DmSetGPIO(HPRF_GPIONUM_N_TX_EN, 0);
}


/**
 * Returns the GPIO status in the lower 3 bits - data is in PPDSDR register
 */
UINT8 MC13192ReadGPIO1_3Status(void)
{
    UINT8 retval = 0;
    BOOL val = 0;

    val = DmReadGPIO(HPRF_GPIONUM_FCC_ID01);
    retval |= val; // ID1 in zero bit

    val = DmReadGPIO(HPRF_GPIONUM_FCC_ID02);
    retval |= (val << 1); // ID2 in 1st bit

    val = DmReadGPIO(HPRF_GPIONUM_FCC_ID03);
    retval |= (val << 2); // ID3 in 2nd bit
    return retval;
}
